function [s,SL,SU]=Bustince(A,B)

%
% [s,SL,SU]=Bustince(A,B)
%
% To compute the similarity between two IT2 FSs A and B using Bustince's
% method:
% 
%  H. Bustince, "Indicator of inclusion grade for interval-valued fuzzy sets.
%  application to approximate reasoning based on interval-valued fuzzy
%  sets," Int'l Journal of Approximate Reasoning, vol. 23, no. 3, pp. 137--209,
%  March 2000.
%
% Dongrui WU (dongruiw@usc.edu), 4/19/2009
%
% A, B: IT2 FSs each defined by nine parameters (see Fig. 1 in Readme.doc)

N=200; % number of discretizations
minX=min(A(1),B(1)); % the range
maxX=max(A(4),B(4));
X=linspace(minX,maxX,N);

lowerA=mg(X,A(5:8),[0 A([9 9]) 0]);
upperA=mg(X,A(1:4));
lowerB=mg(X,B(5:8),[0 B([9 9]) 0]);
upperB=mg(X,B(1:4));

%% min t-norm is used
RLAB=min(min([ones(1,N); min([1-lowerA+lowerB; 1-upperA+upperB])]));
RUAB=min(min([ones(1,N); max([1-lowerA+lowerB; 1-upperA+upperB])]));
RLBA=min(min([ones(1,N); min([1-lowerB+lowerA; 1-upperB+upperA])]));
RUBA=min(min([ones(1,N); max([1-lowerB+lowerA; 1-upperB+upperA])]));
SL=min(RLAB,RLBA);
SU=min(RUAB,RUBA);
s=(SL+SU)/2;

